<?php

class Common_Model_Specialities extends Zend_Db_Table_Abstract
{
    protected $_name = 'specialities';
	protected $_primary = 'id';
	 
	public function getAllZeroSpecialisations($as_array = true)
	{
		$resultSet = $this->fetchAll($this->select()
			->from($this, array('id', 'name'))
			->where('isTitle = ?', 1));
		if (0 == count($resultSet)) return false;
		
		if ($as_array)
		{
			foreach ($resultSet as $k => $v)
			{
				$rs['keys'][$v['id']] = ucfirst(strtolower($v['name']));
				$rs['full'][] = array('id' => $v['id'], 'title' => ucfirst(strtolower($v['name'])));
			}
			return $rs; 
		}
	}
	
	public function getAllSubSpecialisations($as_array = true)
	{
		$resultSet = $this->fetchAll($this->select()
			->from(array('c' => 'specialities'), array('id', 'name','parentSpeciality','generalCode'))
			->order('parentSpeciality', 'asc')
			->setIntegrityCheck(false));
			
		if (0 == count($resultSet)) return false;
		if ($as_array)
		{//echo '<pre>';print_r($resultSet);
			foreach ($resultSet as $k => $v)
			{
				if ($v['parentSpeciality'] == 0)
				{
					$parent[$v['generalCode']] = $v['name'];	
				}
				else 
				{
					//echo $parent[$v['parentSpeciality']].'---'.$v['parentSpeciality'].'<br>';
					$rs['keys'][$v['id']] = ucfirst(strtolower($v['name']));
					$rs['keys_c'][$parent[$v['parentSpeciality']]][$v['id']] = ucfirst(strtolower($v['name']));
				}
				$rs['full'][] = array('id' => $v['id'], 'title' => ucfirst(strtolower($v['name'])));
			}
			//echo '<pre>';print_r($rs['keys_c']);
			return $rs; 
		}
	}
}
